/*
 * Decompiled with CFR 0.152.
 */
import PSG_Emu.OS7_PSG_Driver;
import PSG_Emu.SoundTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LoadSoundAndPlay
extends JApplet {
    boolean isStandalone = false;
    private Vector OS7_Sound_Vector = new Vector();
    private Vector OS7_SoundFile_Vector = new Vector();
    private Vector OS7_SoundTable = new Vector();
    private JComboBox cbox_os7;
    private int cbox_os7_selected_item;
    private JComboBox cbox_sndVector;
    private int cbox_sndVector_selected_item;
    private JTextArea text_snd_data;
    private JButton bt_play;
    private JButton bt_stop;
    private OS7_PSG_Driver psg_os7 = new OS7_PSG_Driver();
    static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public void init() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.set_Vector("- OS7 SoundFX -", "os7snd.txt");
        this.cbox_os7.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = LoadSoundAndPlay.this.cbox_os7.getSelectedIndex();
                if (n != LoadSoundAndPlay.this.cbox_os7_selected_item) {
                    LoadSoundAndPlay.this.cbox_os7_selected_item = n;
                    if (n > 0) {
                        try {
                            String string = (String)LoadSoundAndPlay.this.OS7_SoundFile_Vector.elementAt(n);
                            LoadSoundAndPlay.this.read_file_os7(string);
                        }
                        catch (Exception exception) {
                            System.out.println(exception.toString());
                        }
                    } else {
                        LoadSoundAndPlay.this.reset_cbox_sndVector("no sound");
                    }
                }
            }
        });
        this.init_cbox_sndVector("no sound");
        this.cbox_sndVector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = LoadSoundAndPlay.this.cbox_sndVector.getSelectedIndex();
                if (n != LoadSoundAndPlay.this.cbox_sndVector_selected_item) {
                    LoadSoundAndPlay.this.cbox_sndVector_selected_item = n;
                    if (n > 0) {
                        try {
                            SoundTable soundTable = (SoundTable)LoadSoundAndPlay.this.OS7_SoundTable.elementAt(n - 1);
                            LoadSoundAndPlay.this.text_snd_data.setText(LoadSoundAndPlay.this.toText(soundTable));
                            LoadSoundAndPlay.this.psg_os7.generate(soundTable);
                            LoadSoundAndPlay.this.bt_play.setEnabled(true);
                        }
                        catch (Exception exception) {
                            System.out.println(exception.toString());
                        }
                    } else {
                        LoadSoundAndPlay.this.bt_play.setEnabled(false);
                    }
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.cbox_os7);
        jPanel.add(this.cbox_sndVector);
        container.add((Component)jPanel, "North");
        this.text_snd_data = new JTextArea();
        this.text_snd_data.setText("");
        JScrollPane jScrollPane = new JScrollPane(this.text_snd_data);
        container.add((Component)jScrollPane, "Center");
        this.bt_play = new JButton("Play Sound");
        this.bt_play.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoadSoundAndPlay.this.psg_os7.play();
            }
        });
        this.bt_play.setEnabled(false);
        this.bt_stop = new JButton("Stop Sound");
        this.bt_stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoadSoundAndPlay.this.psg_os7.stop();
            }
        });
        this.bt_stop.setEnabled(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(this.bt_play);
        jPanel2.add(this.bt_stop);
        container.add((Component)jPanel2, "South");
    }

    private void init_cbox_sndVector(String string) {
        this.cbox_sndVector = new JComboBox();
        this.cbox_sndVector.addItem(string);
    }

    private void reset_cbox_sndVector(String string) {
        this.cbox_sndVector.removeAllItems();
        this.cbox_sndVector.addItem(string);
        this.OS7_SoundTable.clear();
        this.text_snd_data.setText("");
    }

    public String getAppletInfo() {
        return "Title: AudioTest  \nAuthor: Daniel Bienvenu  \nThis application let the visitor select and play sounds for new coleco game projects. ";
    }

    public static void main(String[] stringArray) {
        LoadSoundAndPlay loadSoundAndPlay = new LoadSoundAndPlay();
        loadSoundAndPlay.isStandalone = true;
        Frame frame = new Frame(){

            protected void processWindowEvent(WindowEvent windowEvent) {
                super.processWindowEvent(windowEvent);
                if (windowEvent.getID() == 201) {
                    System.exit(0);
                }
            }

            public synchronized void setTitle(String string) {
                super.setTitle(string);
                this.enableEvents(64L);
            }
        };
        frame.setTitle("CV Sound Bank");
        frame.add((Component)loadSoundAndPlay, "Center");
        loadSoundAndPlay.init();
        loadSoundAndPlay.start();
        frame.setSize(480, 360);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((dimension.width - frame.getSize().width) / 2, (dimension.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }

    private void set_Vector(String string, String string2) {
        this.OS7_Sound_Vector.clear();
        String string3 = string;
        this.OS7_Sound_Vector.addElement(string3);
        this.OS7_SoundFile_Vector.clear();
        string3 = "";
        this.OS7_SoundFile_Vector.addElement(string3);
        try {
            InputStream inputStream = this.isStandalone ? new FileInputStream(string2) : new URL(this.getDocumentBase(), string2).openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while (!bufferedReader.ready()) {
            }
            while ((string3 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3.trim(), "|");
                if (!stringTokenizer.hasMoreTokens()) continue;
                this.OS7_Sound_Vector.addElement(stringTokenizer.nextToken());
                this.OS7_SoundFile_Vector.addElement(stringTokenizer.nextToken());
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
        this.cbox_os7 = new JComboBox(this.OS7_Sound_Vector);
    }

    private void read_file_os7(String string) {
        SoundTable soundTable = null;
        boolean bl = string.matches(".*gz");
        this.reset_cbox_sndVector("Select A Sound");
        try {
            String string2;
            InputStream inputStream = this.isStandalone ? (bl ? new GZIPInputStream(new FileInputStream(string)) : new FileInputStream(string)) : (bl ? new GZIPInputStream(new URL(this.getDocumentBase(), string).openStream()) : new URL(this.getDocumentBase(), string).openStream());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            int n = -1;
            this.text_snd_data.setLineWrap(false);
            boolean bl2 = false;
            while ((string2 = bufferedReader.readLine()) != null) {
                char c = string2.charAt(0);
                switch (c) {
                    case ';': {
                        this.text_snd_data.append(string2.substring(1) + "\n");
                        break;
                    }
                    case '@': {
                        ++n;
                        int n2 = string2.charAt(1) - 48;
                        if (n2 > 0) {
                            soundTable = new SoundTable(n2);
                            this.OS7_SoundTable.addElement(soundTable);
                            this.cbox_sndVector.addItem("SoundItem - " + String.valueOf(n + 1));
                        }
                        bl2 = true;
                        break;
                    }
                    case '.': {
                        int n2;
                        bl2 = false;
                        String[] stringArray = string2.substring(1).split("\\s*,\\s*");
                        int n3 = stringArray.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            soundTable.add(stringArray[n2]);
                        }
                        break;
                    }
                    case 'L': {
                        if (!bl2) {
                            soundTable.next_table();
                            break;
                        }
                        bl2 = false;
                        break;
                    }
                }
            }
            inputStream.close();
            soundTable = null;
            System.gc();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public static String toHexString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(hexChar[(byArray[i] & 0xF0) >>> 4]);
            stringBuffer.append(hexChar[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public void destroy() {
        this.psg_os7.kill();
        System.gc();
    }

    public String toText(SoundTable soundTable) {
        String string = new String();
        String string2 = "0";
        String string3 = "h";
        StringTokenizer stringTokenizer = new StringTokenizer(this.psg_os7.comments(soundTable), "|");
        int n = soundTable.numberOfTable();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = soundTable.get_table(i);
            String string4 = LoadSoundAndPlay.toHexString(byArray, soundTable.get_table_length(i));
            String[] stringArray = stringTokenizer.nextToken().split("\\s*;\\s*");
            int n2 = 0;
            string = string + "soundtab".concat(String.valueOf(i + 1)).concat(":\n");
            for (int j = 0; j < stringArray.length; ++j) {
                String[] stringArray2 = stringArray[j].split("\\s*:\\s*");
                int n3 = Integer.parseInt(stringArray2[0], 10);
                string = string + "byte ";
                for (int k = 0; k < n3; ++k) {
                    string = string + string2;
                    string = string + string4.substring(n2, n2 + 2);
                    n2 += 2;
                    string = string + string3;
                    if (k == n3 - 1) continue;
                    string = string + ",";
                }
                string = string + "  ; ";
                string = string + stringArray2[1];
                string = string + "\n";
            }
        }
        return string;
    }
}

